﻿
CREATE PROCEDURE [App].[NVCC_Rebuild_SensitiveDxCodesTable]

AS
--=================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name        : Rebuild_SensitiveDxCodesTable
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 01-21-2016
--
--Changed               : 
--Changed By            : 
--Reason For Change     : 
--
--
--Purpose               : Rebuild table App.NVCC_SensitiveDxCodes, an intermediary
--                        cache of sensitive diagnostic codes to improve NVCC
--                        application performance by eliminating the need for a
--                        separate step to obtain the ICD code SIDS.
--=================================================================================
BEGIN

   SET NOCOUNT ON;

   IF (SELECT OBJECT_ID('app.NVCC_SensitiveDxCodes', 'U')) IS NOT NULL
      DROP TABLE App.NVCC_SensitiveDxCodes

   CREATE TABLE [App].[NVCC_SensitiveDxCodes](
   	   [CodingSystem]  [varchar](12) NOT NULL,
   	   [Sta3n]         [smallint] NULL,
   	   [ICDSID]        [int] NULL,
   	   [Code]          [varchar](12) NOT NULL,
   	   [DiagnosisText] [varchar](255) NOT NULL,
   	   [AbuseDx]       [int] NULL,
   	   [SickleDx]      [int] NULL,
   	   [HIVDx]         [int] NULL
   ) ON [DefFG] WITH (DATA_COMPRESSION = PAGE)

   CREATE UNIQUE CLUSTERED INDEX [NVCC_SensitiveDxCodes_ICDSID]
   ON [App].[NVCC_SensitiveDxCodes] (ICDSID ASC)
   WITH (SORT_IN_TEMPDB = ON, ONLINE = OFF, FILLFACTOR = 95, DATA_COMPRESSION = PAGE)
   ON [DefFG]

   INSERT INTO App.NVCC_SensitiveDxCodes (CodingSystem, Sta3n, ICDSID, Code, DiagnosisText, AbuseDx, SickleDx, HIVDx)
   SELECT c.CodingSystem
   	     ,i.Sta3n
   	     ,i.ICDSID
   	     ,c.Code
   	     ,i.ICDDiagnosisText
   	     ,c.AbuseDx
   	     ,c.SickleDx
   	     ,c.HIVDx
   FROM [App].[NVCC_SensitiveDxBaseCodes] c
   INNER JOIN PanelMgmt.vICD AS i ON c.Code = i.ICDCode


   CREATE UNIQUE NONCLUSTERED INDEX [NVCC_SensitiveDxCodes_Sta3n_ICDCode]
   ON [App].[NVCC_SensitiveDxCodes] (Sta3n, Code)
   INCLUDE (DiagnosisText, AbuseDx, SickleDx, HIVDx)
   WITH (SORT_IN_TEMPDB = ON, ONLINE = OFF, FILLFACTOR = 95, DATA_COMPRESSION = PAGE)
   ON [DefFG]

--select distinct Sta3n from App.NVCC_SensitiveDxCodes order by Sta3n
--select code,count(*) from App.NVCC_SensitiveDxCodes group by code order by code

END




